* Title: Preparing a Help Book
* Slug: new-book

================================================================

A book is a simple folder with pages and images. To create a book, navigate to module's <{path}>/help<{/path}> subfolder (if it does not exist yet, create it by following instructions from <{page name='getting-started'}>Getting Started page<{/page}>).

Books, as you probably guessed, go under <{path}>/books<{/path}>. As mentioned before, a book is just a subfolder with pages and images. To create a new book, just make a subfolder (short name, underscore notation) and add <{path}>/images<{/path}> and <{path}>/pages<{/path}> subfolders to it. Structure will look something like this:

<{code}>/my_module
- /help
-- /books
--- /my_book
---- /images
----- /_cover_large.png
----- /_cover_small.png
---- /pages
---- /index.md<{/code}>

Every book has a cover. Dimensions of large cover should be 260x305px and dimensions of a small cover should be 130x153px. They should be saved as <{path}>_cover_large.png<{/path}> and <{path}>_cover_small.png<{/path}>, respectively.

Also notice <{path}>index.md<{/path}> file. That file contains book details. It's a regular help file (that follows the same <{page name='help-file-anatomy'}>structure<{/page}> as other help files). Available properties are:

### Title

Book title (required). Book titles are not prepared based on naming convention (like other elements), so you should specify book title as a property,

### Description

Short book description (optional).

Content block is used to better describe the book, if needed.

### Show To

List of <{page name="user-groups"}>user groups<{/page}> that this book is visible to. When this attribute is present, book will be displayed only to users that belong to groups listed in it.

### Hide From

List of <{page name="user-groups"}>user groups<{/page}> that this book should be hidden from.

### Position

Numerical position of the book in the list. Start from 1 and go up.

That's it - simply by creating one folder, three files and a couple of subfolders, you created a new book in help section of your application. Check out the next article to learn how to add pages and images to your newly created book.